<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سند  استلام التوزيعات الخاصة بالتوريدة </title>
    
<style>
        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgb(0 0 0 / 15%);
            font-size: 16px;
            line-height: 24px;
            font-family: 'Cairo', sans-serif;
            color: #555;
            text-align: right;
        }

        .top {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            font-size: 20px;
            font-weight: bold;
            padding-bottom: 20px;
            border-bottom: 4px solid #193B62;
        }

        .top span:nth-child(1) {
            display: block;
        }

        .top .right {
            display: flex;
            align-items: center;
            flex-direction: column;
            align-content: center;
        }

        .top .center {
            display: flex;
            align-items: center;

        }

        .information {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: center;
            margin-top: 20px;
            padding-left: 50px;
            padding-right: 50px;
        }



        .information .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .information .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .information-main {

            margin-top: 30px;
            padding-left: 90px;
            padding-right: 90px;
        }



        .information-main .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information-main .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .left span:nth-child(1) {
            display: block;
        }

        .left span:nth-child(2) {
            display: block;
        }

        span {
            margin-right: 8px;
            font-weight: 500;
        }

        .bold {
            font-weight: bold;
        }

        .botom {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 40px;
            padding-left: 20px;
            padding-right: 20px;

        }


        .seg2 {
            display: flex;
            flex-direction: row-reverse;
            justify-content: space-between;
        }

        .botom .seg {
            display: flex;
            flex-direction: column;
            align-content: center;

        }

        .botom .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 10px;
            padding-left: 20px;
            padding-right: 20px;
            margin-bottom: 40px;
        }



        .botom-seg .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .botom-seg .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .top-text {
            display: flex;
            margin-bottom: 20px;
            flex-direction: row-reverse;
        }

        .botom-text {
            display: flex;

            flex-direction: row-reverse;
        }

        table,
        th,
        td {
            border: 1px solid black;
            border-collapse: collapse;
            direction: rtl;
            padding: 10px;
            text-align: center;
            margin-top: 20px;
        }

        @media print {
            .invoice-box {
                max-width: unset;
                box-shadow: none;
                border: 0px;
            }
        }

        @page {
            size: A4 
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <div class="top">
            <div class="left">
                <span>الجمهورية اليمنية</span>
                <span>صنعاء شارع الستين</span>
                <span>+967 773344551</span>
            </div>
            <div class="center">
                <img width="200" src="<?php echo e(asset('/images/logo-full.png')); ?>" alt="">

            </div>
            <div class="right">

                <span class="">رقم السند :
                <?php if(isset($receptId)): ?>
                    <?php echo e($receptId); ?>

                <?php endif; ?></span>
                <span class="">التاريخ :
                    <?php if(isset($dateTime)): ?>
                        <?php echo e(explode(' ',$dateTime)[0]); ?>

                    <?php endif; ?></span>

            </div>

        </div>

        <div class="information">

            <div class="center">
                <span class="bold">سند تأكيد التوزيعات</span>

            </div>

        </div>



        <div class="table">
        <h4>توريدة : <?php if(isset($supply[0]->notice)): ?>
                <?php echo e($supply[0]->notice); ?>

            <?php endif; ?></h4>
            <table style="width: 100%;">
                <tr style="background: #eee;">
                    <th>رقم التوزيعة</th>
                    <th>مصروفة للعميل</th>
                    <th>الكمية</th>
                </tr>
                <?php if(isset($distributions)): ?>
                    <?php $__currentLoopData = $distributions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $distribution): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php if(isset($distribution->id)): ?>
                                <?php echo e($distribution->id); ?>

                            <?php endif; ?></td>
                            <td><?php if(isset($distribution->clint->name)): ?>
                                <?php echo e($distribution->clint->name); ?>

                            <?php endif; ?></td>
                            <td><?php if(isset($distribution->quantity)): ?>
                                <?php echo e($distribution->quantity); ?>

                            <?php endif; ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>


            </table>
            <h4>الاجمالي : <?php if(isset($supply[0]->quantity)): ?>
                <?php echo e($supply[0]->quantity); ?>

            <?php endif; ?></h4>
        </div>
        <div class="botom">

            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المستلم</span>
                    <span><?php if(isset($supply[0]->supplier->name)): ?>
                        <?php echo e($supply[0]->supplier->name); ?>

                    <?php endif; ?></span>
                </div>
                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المحاسب</span>
                    <span><?php if(isset($accounterName)): ?>
                        <?php echo e($accounterName); ?> 
                    <?php endif; ?></span>
                </div>

                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المدير</span>
                    <span><?php if(isset($adminName)): ?>
                        <?php echo e($adminName); ?>

                    <?php endif; ?></span>
                </div>

                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
        </div>




    </div>

</body>

</html>
<?php /**PATH C:\Users\Nasser\Desktop\petrol_store\resources\views/supply/receipt-supply-distribution.blade.php ENDPATH**/ ?>